; CRC-32 calculation routine in Assembly
; Copyright (C) 2002 Davi T. Figueiredo
;
; Used in crc32.e (version 1.32), available from http://www16.brinkster.com/davitf/
;
; Please read crc32.txt for more information and for its license terms
; and disclaimer.


PUSH EAX    ; Store old registers
PUSH EBX
PUSH ECX


MOV  EAX,  [crc_address]    ; get current CRC
MOV  ECX,  char_address     ; get address of current character

CalcCRC:                    ; run once for each character

    MOV  EBX,  EAX          ; copy CRC
    AND  EBX,  #FF          ; keep only the least-significant byte
    XOR  BL,   [ECX]        ; xor the CRC byte with the character

    SHL  EBX,  2            ; * 4 to get the position on the table
    ADD  EBX,  table_address    ; find the position of the value in memory
    SHR  EAX,  8            ;take away the LSB

    XOR  EAX,  [EBX]        ; xor the CRC with the value from the table
    INC  ECX                ; next char

CMP  ECX,  after_chars
JB   CalcCRC    ;Process next char if not all chars have been processed yet

MOV  [crc_address], EAX     ; Copy the CRC to its original place


POP  ECX    ; Restore registers
POP  EBX
POP  EAX
RET


