
//=========================================================
static const byte days[12]
			= { 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

#define UNDEF		100
#define isdigit(c)	((c) >= '0' && (c) <= '9')

// ஢ઠ ४⭮   祭, ᫥  祭
//   '!'   䨪   祭  '!'
static bool assigndate(count d, count m, count y, count c, DATE dd, DATE &ds){
	byte v;
	v = m; if(v == UNDEF+'!') ds.month = dd.month;
	if(v < UNDEF){
 		if(v == 0 || v > 12) return false;
		ds.month = v;
	}

	v = d; if(v == UNDEF+'!') ds.day = dd.day;
	if(v < UNDEF){
		if(v == 0 || v > days[ds.month - 1]) return false;
		ds.day = v;
	}

	v = c;
	if(v < UNDEF && (v < 19 || v > 21)) return false;
	if(v == UNDEF && y < 80) v = 20;
	if(v >= UNDEF) v = ((v == UNDEF+'!' || v == UNDEF && y == UNDEF+'!')
					     ? dd.year : ds.year) / 100;
	if(y >= UNDEF) y = ((y == UNDEF+'!') ? dd.year : ds.year) % 100;
	ds.year = 100 * v + y;
	return true;
}

//---------------------------------------------------------
// ଠ 室 ப  譨 ன ࠭: m/d/y,
// d/m/y  y/m/d,   ⢥ ࠧ⥫ ᪠   
//  '/', '-', '.',   ;  祭 
// ந室  ⥬  ࠢ,    parsedate

static count FAST_ d2v(PCStr &s){
	char ch = *s; s++;
	if(ch == '@' || ch == '!') return UNDEF + ch;
	if(!isdigit(ch)) { s--; return UNDEF; }
	byte v = ch - '0'; ch = *s;
	if(isdigit(ch)) { v = 10 * v + ch - '0', s++; }
	return v;
}

#define datesep(ch, def) ((ch) == '/' || (ch) == '-' \
				|| (ch) == '.' || (ch) == def)

static bool parseldate(PCStr s, DATE ddef, DATE &ds){
	//---  -ࠧ⥫  ଠ  
	COUNTRY cp; count dtformat = 0; char ch;
	if(country(0, &cp)){
		dtformat = cp.co_time; ch = cp.co_dtsep[0];
		if(ch == '@' || ch == '!') ch = '/';
	}else	ch = '/';
	char dtsep = ch;

	count d, m, y, c = UNDEF, v;

	//--- ᪠஢  । 
	if((d = d2v(s)) == UNDEF) return false;
		if(dtformat == 2) { v = d2v(s); if(v != UNDEF) c = d, d = v; }
		ch = *s++; if(!datesep(ch, dtsep)) return false;
		dtsep = ch;
	if((m = d2v(s)) == UNDEF) return false;
		ch = *s++; if(ch != dtsep) return false;
	if((y = d2v(s)) == UNDEF) return false;
		if(dtformat != 2) { v = d2v(s); if(v != UNDEF) c = y, y = v; }
		if(*s) return false;

	//---   室 冷 祭
	v = d;	if(dtformat == 2)   { d = y, y = v; }
		elif(dtformat != 1) { d = m, m = v; }
	return assigndate(d, m, y, c, ddef, ds);
}

//---------------------------------------------------------
// ଠ 室 ப: [[[[c]y]m]d],  c, y, m  d (century, year,
// month  day)  ᨬ '@', '!',    㧭
// ᫮; ᫨  ப   㣨 ,  믮 ⪠
// ᯮ ப  ଠ    ࠭;  '!' 祭
//    ddef,   '@'  ய饭  ᮮ⢥騥
//   ds  ; ᫨ ப  ᮮ⢥ ଠ 
// ᮤন ४ ,  頥 false

static count FAST_ r2v(CStr start, PCStr &s){
	if(s == start) return UNDEF;
	char ch = *--s;
	if(ch == '@' || ch == '!') return UNDEF + ch;
	register byte v = ch - '0';
	if(s > start){
		ch = s[-1]; if(isdigit(ch)) { v += 10 * (ch - '0'), s--; }
	}
	return v;
}

bool parsedate(PCStr s, DATE ddef, DATE &ds){
	PCStr start = s;
	for(;;){
		char ch = *s; if(ch == EOS) break; s++;
		if(!isdigit(ch) && ch != '@' && ch != '!')
			return parseldate(start, ddef, ds);
	}

	//---  
	count	d = r2v(start, s), m = r2v(start, s),
		y = r2v(start, s), c = r2v(start, s);
	return (s > start) ? false : assigndate(d, m, y, c, ddef, ds);
}
