//======================================================================
//
// Free-XDEL: Gnu Gpl version of XDEL for the FreeDOS project
//
// by Alain Mouette 22/may/2002
//
// Licence: at your option:
//  1) GNU GPL
//  2) do whatever you want, but please put an acknowledgement to me :)
//
// Missing from this version:
//  - LFN support (I'll wait for FreeDOS to have it first)
//
// Compiler Borland-C 3.1, Small model, Optimized for speed
//----------------------------------------------------
// To emulate deltree:
//    use /SDRY (/Y only with DR-DOS 7, undocumented)
//    first directory will not be removed
//----------------------------------------------------
// Acknowledgements:
// Thanks to Arkady Belusof for checking my code and
//  suggesting very usefull fixes and improuvements (Ver 2.03)
//----------------------------------------------------
// Version 2.05  1/sep/2005: added kittenization (by Blair Campbell)
// Version 2.06 14/nov/2005: small bug in kitten if lang file not found
//======================================================================

#include <STDIO.H>
#include <STRING.H>
#include <CONIO.H>
#include <CTYPE.H>
#include <DOS.H>
#ifdef __WATCOMC__
#include <DIRECT.H>
//#include <dos.h>
#else
#include <DIR.H>
#endif
#include <STDLIB.H>

#define VERSION "2.06"
//#define debug

//----------------------------------------------------------------------
//--- International messages -------------------------------------------
//----------------------------------------------------------------------

#include "kitten.h"

//----------------------------------------------------------------------
//--- Variables and Constants ------------------------------------------
//----------------------------------------------------------------------

#define OPT_HELP      0x0001
#define OPT_REM_EMPTY 0x0002
#define OPT_NO_WARN   0x0004
#define OPT_OVER_WR   0x0008
#define OPT_PR_EACH   0x0010
#define OPT_DEL_RO    0x0020
#define OPT_SUB_DIR   0x0040
#define OPT_ERROR     0x0080

#define ERR_SYNTAX  1
#define ERR_DELETE  2
#define ERR_MEMORY  3

short options     =0;
char  ctrBrkAbort =0;
char  yesChar    =0;

//----------------------------------------------------------------------
//--- Basic functions --------------------------------------------------
//----------------------------------------------------------------------

#define bool  int                       // C++ definitions
#define true  1
#define false 0
#define StrCpy(dest,src) strNcpy(dest,src,sizeof(dest))
#define StrCat(dest,src) strNcat(dest,src,sizeof(dest))
#define F_MAX (_MAX_DRIVE+_MAX_DIR+_MAX_FNAME+_MAX_EXT)// maximum file name
//--------------------------------------
void help(void)
{
 printf("\n%s:%s", kittengets(0,0, "Free XDEL Extended file delete    Ver"), VERSION);
 printf("\n%s",    kittengets(0,1, "Copyright (c) 2002 Alain Mouette - GNU GPL"));
 printf("\n\n%s",  kittengets(0,2, "XDEL [/options] [@][d:][path]filename[.ext]... [/options]"));
 printf("\n%s",    kittengets(0,3, "  @             the following filename is the name of a file list"));
 printf("\n%s",    kittengets(0,4, "  d:            drive which xdel is to search"));
 printf("\n%s",    kittengets(0,5, "  path          directory where search is to begin"));
 printf("\n%s",    kittengets(0,6, "  filename.ext  file to be deleted (wildcards allowed)"));
 printf("\n%s",    kittengets(0,7, "  /D            remove empty subdirectories"));
 printf("\n%s",    kittengets(0,8, "  /N or /Y      delete specified files with no warning (CAREFUL!)"));
 printf("\n%s",    kittengets(0,9, "  /O            overwrite before deleting - file contents PERMANENTLY LOST"));
 printf("\n%s",    kittengets(0,10,"  /P            prompt before deleting each file"));
 printf("\n%s",    kittengets(0,11,"  /R            delete read-only files"));
 printf("\n%s",    kittengets(0,12,"  /S            delete files in subdirectories"));
 printf("\n%s",    kittengets(0,13,"  /H or /?      this help message"));
 printf("\n\n%s\n",kittengets(0,14,"Multiple files may be specified on the command line."));
}
//--------------------------------------
char *strNcpy(char *dest, const char *src, int size)
{
 if (dest){
  if (src){
   char* s = strncpy(dest,src,size);
   dest[size-1]=0;
   return (s);
  }else{
   dest[0]=0;
   return (dest);
  }
 }else
  return (0);
}
//--------------------------------------
char *strNcat(char *dest, const char *src, int size)
{
 char* s;
 if (src){
  int len=strlen(dest);
  if (len<size)
   s = strncat(dest,src,size-len);
  dest[size-1]=0;
  return (s);
 }else
  return (dest);
}

//----------------------------------------------------------------------
//--- Program... -------------------------------------------------------
//----------------------------------------------------------------------

//--------------------------------------
#define BUF_SIZE 4096  // Has to be multiple of 32 !!!
static char* wipeBuf=0;

short WipeFile(const char* file,const unsigned long size)
{
 FILE* fp;
 int i,retValue=0;
 unsigned long l;
 // Open file to wipe first
 if ((fp = fopen(file,"r+b"))!=NULL){
  // check if buffer is prepared
  if (!wipeBuf){
   wipeBuf=new char[BUF_SIZE];
   if (!wipeBuf){
    printf("\n %s\n", kittengets(1, 7, "Error: Out of Memory"));
    return(ERR_MEMORY);
   }
   for (i=0;i<BUF_SIZE;i+=32)
    memcpy(&wipeBuf[i],"Completely deleted by FreeXDEL\r\n",32);//fraction of buff!
  }
  // wipe it
  l=size;
  while(l>=BUF_SIZE && !feof(fp)){
   fwrite(wipeBuf,BUF_SIZE,1,fp);       // write full blocks
   l-=BUF_SIZE;
  }
  if (l)
   fwrite(wipeBuf,(int)l,1,fp);         // here l<BUF_SIZE
  fclose(fp);
 }else{
  retValue=ERR_DELETE;                  // error deleting
 }
 return(retValue);
}
//--------------------------------------
bool AskYes(void)
{
 char ch;
 if (ctrBrkAbort)                       // has been aborted earlier
  return(false);
 ch=toupper(getch());
 if (ch==0x03)                          // test Ctrl-C
  ctrBrkAbort=1;
 if (isprint(ch))
  putch(ch);
 if (ch!=yesChar || ctrBrkAbort)
  return(false);
 return(true);
}
//--------------------------------------
bool AskDelete(const char* dir,const char* file)
{
 char *fullDir;
 bool retValue=true;
 fullDir= new char[F_MAX];
 if (_fullpath(fullDir,dir,F_MAX) != NULL){
  while(kbhit()) getch();
  printf("\n   %s: %s\n   %s: %s\n%s", kittengets(2, 0, "path"), fullDir, kittengets(2, 1, "file"), file, kittengets(2, 2, "Is this what you wish to do? [yn]"));
  if (!AskYes())
   retValue=false;
 }else{
  strNcpy(fullDir,dir,F_MAX);strNcat(fullDir,file,F_MAX);
  printf("\n %s \"%s\"", kittengets(1, 3, "Invalid name in"), fullDir);
  retValue=false;
 }
 delete []fullDir;
 return(retValue);
}
//--------------------------------------
bool AskDeleteFile(const char* file)
{
 char *fullName;
 bool retValue=true;
 fullName= new char[F_MAX];
 if (_fullpath(fullName,file,F_MAX) != NULL){
  while(kbhit()) getch();
  printf("\n %s: %s?", kittengets(1, 0, "Delete file [yn]"), fullName);
  if (!AskYes())
   retValue=false;
 }else
  retValue=false;
 delete []fullName;
 return(retValue);
}

//--------------------------------------
int xDel2(const char* dir,const char* name)// delete files: one level
{
 char *file;
 struct find_t *ff;
 int dirDone,attr,err;
 int retValue=0;

 file = new char[F_MAX];                // use heap instead of stack
 ff   = new find_t;

 #ifdef debug
 printf("\n>>apagando dir=[%s] name=[%s]",dir,name);
 #endif
 //--- Delete ---
 strNcpy(file,dir,F_MAX);strNcat(file,name,F_MAX);
 #ifdef __WATCOMC__
 attr=_A_HIDDEN|_A_SYSTEM|_A_ARCH|_A_SUBDIR;
 #else
 attr=FA_HIDDEN|FA_SYSTEM|FA_ARCH|FA_DIREC;
 #endif
 if (options&OPT_DEL_RO)                // include ReadOnly files
  #ifdef __WATCOMC__
  attr|=_A_RDONLY;
  #else
  attr|=FA_RDONLY;
  #endif
 dirDone = _dos_findfirst(file,attr,ff);
 while (!dirDone && !ctrBrkAbort){
  strNcpy(file,dir,F_MAX);strNcat(file,ff->name,F_MAX);// complete file name
  #ifdef __WATCOMC__
  if (ff->attrib&_A_SUBDIR){
  #else
  if (ff->attrib&FA_DIREC){
  #endif
   if (strcmp(ff->name,".") && strcmp(ff->name,"..")){
    //---Recurse SubDirectories---
    if (options&OPT_SUB_DIR){
     strNcat(file,"\\",F_MAX);          // nome do novo diretrio
     #ifdef debug
     printf("\n reentrando diretorio=[%s]",file);
     #endif
     err=xDel2(file,name);              // Recurse new directory
     if (err > retValue)
      retValue = err;                   // Keep higher error
    }
    //---remove empty directories---
    if (options&OPT_REM_EMPTY){
     file[strlen(file)-1]=0;            // remove final '\\'
     #ifdef debug
     printf("\n apagando diretorio=[%s]",file);
     #endif
     if (rmdir(file)!=0)                // will succeed only if empty
      printf("\n %s: %s", kittengets(1, 5, "Could not delete directory"), file);
    }
   }
  }else{
   //---delete files---
   #ifdef debug
   printf("\n apagando arq=[%s] attrib=%02x",file,ff->attrib);
   #endif
   #ifdef __WATCOMC__
   if (!(ff->attrib&_A_RDONLY) || (options&OPT_DEL_RO)){//double check (bug?)
   #else
   if (!(ff->attrib&FA_RDONLY) || (options&OPT_DEL_RO)){//double check (bug?)
   #endif
    if ((options&OPT_PR_EACH)&&!AskDeleteFile(file))// prompt each file
     retValue=ERR_DELETE;               // error deleting file...
    else{
     #ifdef __WATCOMC__
     if (ff->attrib&(~_A_ARCH))
     #else
     if (ff->attrib&(~FA_ARCH))
     #endif
      _dos_setfileattr(file,0);         // remove attributes
     if (options&OPT_OVER_WR){
      err=WipeFile(file,ff->size);
      if (err > retValue)
       retValue = err;                  // Keep higher error
     }
     if (remove(file)!=0){
       printf("\n %s: %s", kittengets(1, 4, "Could not delete file"), file);
       retValue=ERR_DELETE;
     }
    }
   }
  }
  dirDone = _dos_findnext(ff);
 }
 #ifdef __WATCOMC__
  _dos_findclose(ff);
 #endif
 delete []file;
 delete ff;
 return (retValue);
}
//--------------------------------------
int xDel(const char* fName)             // Prepare names for deletion
{
 char *dir,*name;
 int retValue;
 char tDrive[_MAX_DRIVE];
 char tDir[_MAX_DIR];
 char tFile[_MAX_FNAME];
 char tExt[_MAX_EXT];

 dir  = new char[F_MAX];                // use heap instead of stack
 name = new char[F_MAX];
 _splitpath(fName,tDrive,tDir,tFile,tExt);
 if (!tFile[0]){                        // no file in name
  printf("\n %s \"%s\"", kittengets(1, 3, "Invalid name in"), fName);
  retValue=ERR_DELETE;                  // returns error
 }else{
  _makepath(dir,tDrive,tDir,0,0);       // starting directory
  _makepath(name,0,0,tFile,tExt);       // only name and extention
  strupr(dir);
  strupr(name);
  if (!(options&OPT_NO_WARN)&&!AskDelete(dir,name))// no Warning
   retValue=ERR_DELETE;                 // error deleting file...
  else
   retValue=xDel2(dir,name);            // Deletes first level
 }
 delete []dir;
 delete []name;
 return(retValue);
}
//--------------------------------------
void CheckOption(const char* opt)
{
 short i,len;
 if (!stricmp(opt,"/help")){
  options|=OPT_HELP;
  return;
 }
 len=strlen(opt);
 if (len==1){
  printf("\n %s \"%s\"", kittengets(1, 2, "Invalid option in"), opt);
  options|=OPT_ERROR;
  return;
 }
 for (i=1;i<len;i++)
  switch (toupper(opt[i])){
   case 'D':
    options|=OPT_REM_EMPTY;
    break;
   case 'N':
   case 'Y':
    options|=OPT_NO_WARN;
    break;
   case 'O':
    options|=OPT_OVER_WR;
    break;
   case 'P':
    options|=OPT_PR_EACH;
    break;
   case 'R':
    options|=OPT_DEL_RO;
    break;
   case 'S':
    options|=OPT_SUB_DIR;
    break;
   case 'H':
   case '?':
    options|=OPT_HELP;
    break;
   default:
    printf("\n %s \"%s\"", kittengets(1, 2, "Invalid option in"), opt);
    options|=OPT_ERROR;
    return;
  }
}
//--------------------------------------
int main(int argc, char **argv)
{
 short firstFile=0;                     // file names in comand line
 short lastFile=0;
 short i,j,k,err,retValue;
 char *fileName;
 FILE * fp;                             // for file lists

 kittenopen("xdel");                    // open the translation catalog
 yesChar=toupper(kittengets(2, 3, "Y")[0]);// set yesChar according to %lang%

 #ifdef debug
 clrscr();
 #endif

 if (argc<=1){
  help();
  kittenclose();
  return(1);
 }
 // --- options ---
 for (i=1;i<argc && !(options&OPT_ERROR) && argv[i][0]=='/';i++)
  CheckOption(argv[i]);
 if (i<argc){
  firstFile=i;                          // remaining parameters are File Names
  for (i=argc-1;i>0 && !(options&OPT_ERROR) && argv[i][0]=='/';i--)
   CheckOption(argv[i]);
  if (i>=firstFile)
   lastFile=i;                          // preceding parameters are File Names
 }
 // --- errors ---
 if (options&OPT_ERROR){
  kittenclose();
  return(1);
 }
 if (!firstFile || !lastFile){          // no name ramains
  if ((options&OPT_HELP)==OPT_HELP || !options)
   help();
  else
   printf("\n %s\n", kittengets(1, 1, "No file name specified"));
  kittenclose();
  return(1);
 }
 // --- write Help ---
 if (options&OPT_HELP){
  printf("\n %s\n", kittengets(1, 1, "No file name specified"));
  kittenclose();
  return(1);
 }

 #ifdef debug
 printf("\n Options=%04x files: %d-%d",options,firstFile,lastFile);
 for (i=firstFile;i<=lastFile;i++)
  printf("\n File[%d]=[%s]",i,argv[i]);
 #endif

 // --- Start Operation ---
 retValue=0;
 fileName=new char[F_MAX];              // use heap for smaller executable!
 for (i=firstFile;i<=lastFile&&!ctrBrkAbort;i++){// command line list
  if (argv[i][0]=='@'){
   // --- File List ---
   if ((fp = fopen(&argv[i][1],"rt"))!=NULL){
    do{
     errno=0;
     if (fgets(fileName,F_MAX,fp)==NULL){// read one line
      if (errno){
       printf("\n %s: [@]%s", kittengets(1, 6, "Error reading file"), &argv[i][1]);
       break;                           // error reading file
      }else
       continue;
     }
     // --- Clean File Name ---
     strupr(fileName);
     j=strlen(fileName)-1;              // remove SP,TAB e LF on the right
     while ((j>=0)&&((fileName[j]==' ')||(fileName[j]=='\n')||(fileName[j]==9))) j--;
     fileName[++j]=0;
     k=0;                                               // remove SP e TAB on the left
     while ((k<=j)&&((fileName[k]==' ')||(fileName[k]==9))) k++;
     if ((fileName[k]==0)||(fileName[k]==';')||
         ((fileName[k]=='/')&&(fileName[k+1]=='/')))
      continue;                         // Comment [;|//] or empty
     err=xDel(&fileName[k]);
     if (err > retValue)
      retValue = err;                   // don't use macro on function
    }while (!feof(fp));
    fclose(fp);
   }else{
     printf("\n %s: [@]%s", kittengets(1, 6, "Error reading file"), &argv[i][1]);
   }
  }else{
   // --- file from command line ---
   err=xDel(argv[i]);
   if (err > retValue)
    retValue = err;                      // don't use macro on function
  }
 }
 delete []fileName;
 if (wipeBuf)
  delete []wipeBuf;                      // static buffer for wipe
 //printf("\n");
 kittenclose();
 return(retValue);
}
